<?php
// Simple License Validator — returns JSON status for a given license key

header('Content-Type: application/json');

$LICENSES_FILE = __DIR__ . '/data/licenses.json';

function respond($status, $name = null, $plan = null, $expiry = null, $message = null) {
    $out = ['status' => $status];
    if ($name)    $out['name']    = $name;
    if ($plan)    $out['plan']    = $plan;
    if ($expiry)  $out['expiry']  = $expiry;
    if ($message) $out['message'] = $message;
    echo json_encode($out, JSON_PRETTY_PRINT);
    exit;
}

// ── Input ────────────────────────────────────────────────────────────────────

$input     = json_decode(file_get_contents('php://input'), true) ?? [];
$key       = trim($input['license_key'] ?? $_GET['license_key'] ?? '');
$device_id = trim($input['device_id']   ?? $_GET['device_id']   ?? '');

if ($key === '') {
    http_response_code(400);
    respond('error', null, null, null, 'license_key is required');
}

// ── Load license store ───────────────────────────────────────────────────────

if (!file_exists($LICENSES_FILE)) {
    http_response_code(500);
    respond('error', null, null, null, 'License store not found');
}

$licenses = json_decode(file_get_contents($LICENSES_FILE), true);

if (!isset($licenses[$key])) {
    respond('not_found');
}

$lic = $licenses[$key];

// ── Checks ───────────────────────────────────────────────────────────────────

if ($lic['revoked']) {
    respond('revoked');
}

if ($lic['expiry'] !== null && $lic['expiry'] < date('Y-m-d')) {
    respond('expired', null, $lic['plan'], $lic['expiry']);
}

// Device binding — bind on first use, enforce on subsequent calls
if ($device_id !== '') {
    if ($lic['device_id'] === null) {
        $licenses[$key]['device_id'] = $device_id;
        file_put_contents($LICENSES_FILE, json_encode($licenses, JSON_PRETTY_PRINT));
    } elseif ($lic['device_id'] !== $device_id) {
        respond('invalid', null, null, null, 'Device mismatch');
    }
}

respond('valid', $lic['name'] ?? null, $lic['plan'], $lic['expiry']);